/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.schedops.schedulables;

import com.ibm.hwmca.base.updates.ChangeMgmtInfo;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.schedops.HMCSchedulable;
import com.ibm.hwmca.fw.schedops.HMCScheduler;
import com.ibm.hwmca.fw.schedops.OperationTarget;
import com.ibm.hwmca.fw.schedops.Schedulable;
import com.ibm.hwmca.fw.schedops.SchedulableDescriptor;
import com.ibm.hwmca.fw.schedops.SchedulableException;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.schedops.SchedulerException;
import com.ibm.hwmca.fw.system.RestartManager;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public class SingleStepRetrieveApplySchedulable
implements HMCSchedulable {
    private static final String CLASS_NAME = "[base/schedops/SingleStepRetrieveApplySchedulable] ";
    private static final String TRACE_MASKT = "XTIMACPT";
    private static final String TRACE_MASKF = "XTIMACPF";
    private static final String TRACE_MASKD = "XTIMACPD";
    private static final String RESTART_CLASS = "com.ibm.hwmca.base.updates.ConsoleSingleStepMclRestartTasklet";
    private SchedulableDescriptor descriptor = null;

    public SingleStepRetrieveApplySchedulable() {
        Trace.trace(TRACE_MASKT, "[base/schedops/SingleStepRetrieveApplySchedulable] <> SingleStepRetrieveApplySchedulable()");
    }

    protected SingleStepRetrieveApplySchedulable(PersistentData data) {
        Trace.trace(TRACE_MASKT, "[base/schedops/SingleStepRetrieveApplySchedulable] <> SingleStepRetrieveApplySchedulable( PersistentData )");
    }

    public synchronized SchedulableDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new Descriptor();
        }
        return this.descriptor;
    }

    public Object performScheduledOperation(ScheduledOperation schedop) throws SchedulableException {
        Trace.trace(TRACE_MASKT, "[base/schedops/SingleStepRetrieveApplySchedulable] >> performScheduledOperation()");
        Trace.trace(TRACE_MASKD, "[base/schedops/SingleStepRetrieveApplySchedulable] calling UpdateUtilities");
        UpdateUtilities utility = new UpdateUtilities();
        utility.singleStep(0, null, false, true);
        if (utility.isShutdownPending()) {
            try {
                HMCScheduler.getHMCScheduler().markDisruptiveOperationComplete(schedop);
            }
            catch (SchedulerException se) {
                throw new SchedulableException(se);
            }
            ChangeMgmtInfo cmInfo = ChangeMgmtInfo.getChangeMgmtInfo();
            int saveOperation = ChangeMgmtInfo.SS_INSTALL;
            cmInfo.setSstepOperation(saveOperation);
            cmInfo.setMultiPass(utility.isApplyOrRejectMultiPass());
            RestartManager rm = RestartManager.getRestartManager();
            rm.addPostInit(RESTART_CLASS);
            utility.performShutdown();
        }
        Trace.trace(TRACE_MASKT, "[base/schedops/SingleStepRetrieveApplySchedulable] << performScheduledOperation()");
        return null;
    }

    public PersistentData getPersistentData() {
        return new PersistedData();
    }

    public boolean isUpgradeData() {
        return false;
    }

    public static class Descriptor
    implements SchedulableDescriptor {
        public LocalizableText getDescription() {
            return new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", "XTIM.SS_RETAPP");
        }

        public Schedulable createSchedulable(OperationTarget target) {
            return new SingleStepRetrieveApplySchedulable();
        }

        public boolean isDisplayableOnUI(OperationTarget target) {
            return true;
        }

        public boolean isSelectableOnUI(OperationTarget target) {
            return true;
        }

        public String getOperationParametersTasklet() {
            return null;
        }
    }

    private static class PersistedData
    implements PersistentData {
        private PersistedData() {
        }
    }
}

